<?php

class EWRporta_ControllerPublic_Portal extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$options = XenForo_Application::get('options');
		$viewParams = array();

		if ($options->EWRporta_threadcount)
		{
			$visitor = XenForo_Visitor::getInstance()->toArray();

			$conditions = array(
				'deleted' => false,
				'moderated' => false,
			);

			$fetchOptions = array(
				'join' => XenForo_Model_Thread::FETCH_FORUM | XenForo_Model_Thread::FETCH_USER,
				'readUserId' => $visitor['user_id'],
				'postCountUserId' => $visitor['user_id'],
				'order' => 'last_post_date',
				'limit' => $options->EWRporta_threadcount,
			);

			$threads = $this->getModelFromCache('XenForo_Model_Thread')->getThreads($conditions, $fetchOptions);

			foreach ($threads AS &$thread)
			{
				$thread = $this->getModelFromCache('XenForo_Model_Thread')->prepareThread($thread, $thread);
				$thread['canInlineMod'] = false;
				$thread['canEditThread'] = false;
			}

			$viewParams['visitor'] = $visitor;
			$viewParams['threads'] = $threads;
			$viewParams['showForumLink'] = true;
		}

		$viewParams['newsList'] = $this->getModelFromCache('EWRporta_Model_Threads')->getRecent();

		return $this->responseView('EWRporta_ViewPublic_Portal', 'EWRporta_Portal', $viewParams);
	}
}